/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.exports;

import java.io.File;
import javax.swing.JOptionPane;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.exports.ExportDispatcher;
import org.homelinux.elabor.scriptorium.exports.ExportProcessor;

public class ExportHelper {
    public static String getLabel(String id) {
        return id.replaceAll("\\W", "");
    }

    public static void export(ExportDispatcher dispatcher, ExportProcessor processor, Edition edition) {
        try {
            if (edition == null) {
                File[] files = dispatcher.chooseEditionFiles();
                if (files.length == 0) {
                    dispatcher.operationCancelled();
                } else {
                    File exportFile = dispatcher.chooseExportFile();
                    if (exportFile == null) {
                        dispatcher.operationCancelled();
                    } else {
                        processor.startProcess(exportFile);
                        dispatcher.processFiles(files, processor, false);
                        processor.endProcess();
                    }
                }
            } else {
                File editionFile = edition.getFile();
                if (editionFile == null) {
                    String message = "impossibile exportare un documento non registrato";
                    JOptionPane.showMessageDialog(null, message, "error", 0);
                } else {
                    File exportFile = dispatcher.forceExtension(editionFile);
                    processor.startProcess(exportFile);
                    processor.processEdition(edition);
                    processor.endProcess();
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            String message = exc.getMessage();
            JOptionPane.showMessageDialog(null, message, "error", 0);
        }
    }
}

