/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes;

import java.awt.Shape;
import java.awt.geom.Point2D;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.EditionListener;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.AbstractBasicShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeVisitable;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.w3c.dom.Element;

public abstract class AbstractShape<T extends EditionComponent<T>>
extends AbstractBasicShape<T>
implements ShapeVisitable {
    public AbstractShape() {
    }

    public AbstractShape(Element element) {
        super(element);
    }

    public AbstractShape(ScriptoriumShape parent, EditionListener listener) {
        super(parent);
        this.setListener(listener);
    }

    public AbstractShape(EditionComponent<?> parent) {
        super(parent);
    }

    public abstract int getNeededNumberOfPoints();

    public int getPointsNumber() {
        return this.getPointReferences().size();
    }

    public boolean isComplete() {
        return this.getPointsNumber() >= this.getNeededNumberOfPoints();
    }

    @Override
    public boolean canAddPoint() {
        return !this.isComplete();
    }

    public String getNextUndefinedPointName() {
        String retValue = this.canAddPoint() ? this.getPointName(this.getPointReferences().size()) : null;
        return retValue;
    }

    public abstract String getPointName(int var1);

    public abstract Shape getShape(Point2D[] var1);

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }
}

