/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes;

import java.awt.geom.Point2D;
import java.util.List;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComposite;
import org.homelinux.elabor.scriptorium.ecomponents.EditionListener;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.CharRotation;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.AbstractPointReference;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.PointReference;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.LabelAnchorType;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.LabelRotationType;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeAdapter;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeAttribute;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeReference;
import org.homelinux.elabor.scriptorium.ndraft.actions.ActionPoint;
import org.w3c.dom.Element;

public abstract class AbstractBasicShape<T extends EditionComponent<T>>
extends EditionComposite<T> {
    private static final String LABEL = "label";
    private static final String LABEL_ANCHOR_TYPE = "label_anchor_type";
    private static final String LABEL_X = "label_x";
    private static final String LABEL_Y = "label_y";
    private static final String LABEL_ROTATION = "label_rotation";
    private static final String LABEL_ROTATION_TYPE = "label_rotation_type";
    private static final String JOINING_ROTATION = "joining_rotation";
    private static final String CHAR_ROTATE = "char_rotate";
    private static final String CHAR_ROTATION = "char_rotation";
    private static final String CHAR_INTERSPACE = "char_interspace";
    private static final String VISIBLE = "visibility";
    private static final String LINE_STYLE = "style";
    private static final String LINE_WIDTH = "line_width";
    private static final String LINE_COLOR = "line_color";

    public AbstractBasicShape() {
    }

    public AbstractBasicShape(Element element) {
        super(element);
    }

    public AbstractBasicShape(ScriptoriumShape parent, EditionListener listener) {
        super(parent);
        this.setListener(listener);
    }

    public AbstractBasicShape(EditionComponent<?> parent) {
        super(parent);
    }

    public void setShapeAttributeValue(String name, boolean value) {
        ShapeAttribute attribute = this.getShapeAttribute(name);
        attribute.setName(name);
        attribute.setValue(value);
    }

    private ShapeAttribute getShapeAttribute(String name) {
        List<ShapeAttribute> attributes = this.getShapeAttributes();
        ShapeAttribute attribute = null;
        for (ShapeAttribute shapeAttr : attributes) {
            if (!shapeAttr.getName().equals(name)) continue;
            attribute = shapeAttr;
        }
        if (attribute == null) {
            boolean value = this.getBooleanAttribute(name, false);
            this.removeAttribute(name);
            attribute = new ShapeAttribute(this);
            this.addFirstChild(attribute);
            attribute.setName(name);
            attribute.setValue(value);
        }
        return attribute;
    }

    public boolean getShapeAttributeValue(String name) {
        ShapeAttribute attribute = this.getShapeAttribute(name);
        return attribute == null ? false : attribute.getValue();
    }

    public List<ShapeAttribute> getShapeAttributes() {
        return this.getNodesByType(new ShapeAttribute());
    }

    public void setLabel(String label) {
        this.setStringAttribute(LABEL, label);
    }

    public String getLabel() {
        return this.getStringAttribute(LABEL);
    }

    public void setLabelAnchorType(LabelAnchorType anchorType) {
        String stringAnchor = anchorType.toString();
        this.setStringAttribute(LABEL_ANCHOR_TYPE, stringAnchor);
    }

    public LabelAnchorType getLabelAnchorType() {
        String stringAnchor = this.getStringAttribute(LABEL_ANCHOR_TYPE);
        LabelAnchorType anchorType = stringAnchor.isEmpty() ? this.getOldFilesAnchorType() : LabelAnchorType.valueOf(stringAnchor);
        return anchorType;
    }

    private LabelAnchorType getOldFilesAnchorType() {
        Point2D absoluteP = this.getLabelPosition();
        double x = absoluteP.getX();
        double y = absoluteP.getY();
        LabelAnchorType anchorType = x == 0.0 && y == 0.0 ? LabelAnchorType.UPPERRIGHT : LabelAnchorType.ABSOLUTE;
        return anchorType;
    }

    public void setLabelPosition(Point2D position) {
        this.setDoubleAttribute(LABEL_X, position.getX());
        this.setDoubleAttribute(LABEL_Y, position.getY());
    }

    public Point2D getLabelPosition() {
        double x = this.getDoubleAttribute(LABEL_X);
        double y = this.getDoubleAttribute(LABEL_Y);
        String stringAnchor = this.getStringAttribute(LABEL_ANCHOR_TYPE);
        if (stringAnchor.isEmpty() && x == 0.0 && y == 0.0) {
            y = 0.0;
            x = 0.0;
        }
        Point2D.Double position = new Point2D.Double(x, y);
        return position;
    }

    public void setLabelRotation(int rotation) {
        this.setIntAttribute(LABEL_ROTATION, rotation);
    }

    public int getLabelRotation() {
        return this.getIntAttribute(LABEL_ROTATION);
    }

    public void setLabelRotationType(LabelRotationType rotationType) {
        String stringRotationType = rotationType.toString();
        this.setStringAttribute(LABEL_ROTATION_TYPE, stringRotationType);
    }

    public LabelRotationType getLabelRotationType() {
        boolean isJoiningRotation;
        String stringRotation = this.getStringAttribute(LABEL_ROTATION_TYPE);
        LabelRotationType rotationType = null;
        rotationType = stringRotation.isEmpty() ? ((isJoiningRotation = this.getBooleanAttribute(JOINING_ROTATION, false)) ? LabelRotationType.FIRST_AND_SECOND : LabelRotationType.EXPLICIT) : LabelRotationType.valueOf(stringRotation);
        return rotationType;
    }

    public void setCharRotation(CharRotation charRotation) {
        String stringCharRotation = charRotation.toString();
        this.setStringAttribute(CHAR_ROTATION, stringCharRotation);
        this.removeAttribute(CHAR_ROTATE);
    }

    public CharRotation getCharRotation() {
        boolean charRotate;
        String stringCharRotation = this.getStringAttribute(CHAR_ROTATION);
        CharRotation charRotation = stringCharRotation.isEmpty() ? ((charRotate = this.getBooleanAttribute(CHAR_ROTATE, true)) ? CharRotation.NORMAL : CharRotation.VERTICAL) : CharRotation.valueOf(stringCharRotation);
        return charRotation;
    }

    public void setCharInterspace(double charInterspace) {
        this.setDoubleAttribute(CHAR_INTERSPACE, charInterspace);
    }

    public double getCharInterspace() {
        String stringCharInterspace = this.getStringAttribute(CHAR_INTERSPACE);
        double charInterspace = stringCharInterspace.isEmpty() ? 0.0 : Double.parseDouble(stringCharInterspace);
        return charInterspace;
    }

    public void setVisible(boolean visible) {
        this.setBooleanAttribute(VISIBLE, visible);
    }

    public boolean isVisible() {
        return this.getBooleanAttribute(VISIBLE, true);
    }

    public void setStyleName(String styleName) {
        this.setStringAttribute(LINE_STYLE, styleName);
        this.removeAttribute(LINE_WIDTH);
        this.removeAttribute(LINE_COLOR);
    }

    public String getStyleName() {
        return this.getStringAttribute(LINE_STYLE);
    }

    public boolean addPoint(AbstractPointReference<?> point) {
        EditionListener listener = this.getListener();
        PointReference reference = new PointReference(point, listener);
        return this.addReference(reference);
    }

    private boolean addPoint(PointReference reference) {
        EditionListener listener = this.getListener();
        reference.setListener(listener);
        return this.addReference(reference);
    }

    private boolean addReference(PointReference reference) {
        boolean ok = this.canAddPoint();
        if (ok) {
            this.addChild(reference);
        }
        return ok;
    }

    protected abstract boolean canAddPoint();

    public void removePoint(AbstractPointReference<?> point) {
        for (PointReference reference : this.getPointReferences()) {
            if (reference.getId() != point.getId()) continue;
            this.removeChild(reference);
        }
    }

    public void setPoints(Iterable<PointReference> points) {
        for (PointReference ref : this.getPointReferences()) {
            this.removeChild(ref);
        }
        for (PointReference ref : points) {
            this.addPoint(ref);
        }
    }

    public List<PointReference> getPointReferences() {
        return this.getNodesByType(new PointReference());
    }

    public List<ScriptoriumPoint> getPoints(Iterable<ScriptoriumPoint> drawingPoints) {
        List<PointReference> pointReferences = this.getPointReferences();
        return ShapeAdapter.getReferredPoints(pointReferences, drawingPoints);
    }

    public List<ActionPoint> getActionPoints() {
        return this.getNodesByType(new ActionPoint());
    }

    public List<ShapeReference> getShapeReferences() {
        return this.getNodesByType(new ShapeReference());
    }
}

