/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.drawing;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.CharRotationManager;

class VerticalCRManager
implements CharRotationManager {
    VerticalCRManager() {
    }

    @Override
    public void drawString(Graphics2D graphics, String string, double x, double y, double theta, double charInterspace) {
        AffineTransform rot = new AffineTransform();
        rot.rotate(theta, x, y);
        FontMetrics metrics = graphics.getFontMetrics();
        int height = metrics.getAscent() - metrics.getDescent();
        int length = height * string.length();
        int posX = (int)(x - (double)(length / 2));
        int posY = (int)y;
        int index = 0;
        while (index < string.length()) {
            String substring = string.substring(index, index + 1);
            int width = metrics.stringWidth(substring);
            Point2D.Double charPoint = new Point2D.Double(posX + height / 2, posY);
            Point2D trPoint = rot.transform(charPoint, null);
            int xc = (int)trPoint.getX();
            int yc = (int)trPoint.getY();
            graphics.drawString(substring, xc - width / 2, yc + height / 2);
            posX += height;
            ++index;
        }
    }
}

