/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.drawing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyReferenceNonvaluedComposite;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.ComponentType;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Drawing;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Glyph;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.IdentifiedComponent;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.PointReference;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.Reference;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeReference;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.w3c.dom.Element;

public class GlyphGroup
extends OntologyReferenceNonvaluedComposite<GlyphGroup>
implements ComponentFactory<GlyphGroup>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Drawing drawing;

    public GlyphGroup() {
    }

    public GlyphGroup(EditionComponent<?> parent) {
        super(parent);
        this.drawing = (Drawing)this.getParent();
    }

    public GlyphGroup(Element element) {
        super(element);
    }

    public void setDrawing(Drawing drawing) {
        this.drawing = drawing;
    }

    @Override
    @Deprecated
    public GlyphGroup make(Element element) {
        return new GlyphGroup(element);
    }

    @Override
    public String getElementName() {
        return ComponentType.GLYPHGROUP.getName();
    }

    public void setName(String name) {
        this.setStringAttribute("name", name);
    }

    public String getName() {
        return this.getStringAttribute("name");
    }

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }

    private List<Reference> getReferences() {
        ArrayList<Reference> references = new ArrayList<Reference>();
        for (PointReference pointReference : this.getNodesByType(new PointReference())) {
            references.add(pointReference);
        }
        for (ShapeReference shapeReference : this.getNodesByType(new ShapeReference())) {
            references.add(shapeReference);
        }
        return references;
    }

    public List<Glyph> getGlyphs() {
        ArrayList<Glyph> glyphs = new ArrayList<Glyph>();
        for (Reference reference : this.getReferences()) {
            glyphs.add(reference.getGlyph(this.drawing));
        }
        return glyphs;
    }

    public void addGlyph(Glyph glyph) {
        IdentifiedComponent<?> glyphReference = glyph.getReference();
        this.addFirstChild(glyphReference);
    }

    public void removeGlyph(Glyph glyph) {
        for (Reference reference : this.getReferences()) {
            IdentifiedComponent<?> glyphRef = glyph.getReference();
            if (reference.getId() != glyphRef.getId() || reference.getClass() != glyphRef.getClass()) continue;
            this.removeChild((EditionComponent)((Object)reference));
            break;
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

