/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.drawing;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComposite;
import org.homelinux.elabor.scriptorium.ecomponents.EditionListener;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.BackgroundImage;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Glyph;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.GlyphGroup;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Transform;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.PointReference;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.AbstractShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeReference;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.StyleSetReference;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.w3c.dom.Element;

public class Drawing
extends EditionComposite<Drawing>
implements ComponentFactory<Drawing>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ORIGIN_X_NAME = "x_origin";
    private static final String ORIGIN_Y_NAME = "y_origin";
    private static final String WIDTH_ATTRIBUTE_NAME = "width";
    private static final String HEIGHT_ATTRIBUTE_NAME = "height";
    private static final String CAPTION_ATTRIBUTE_NAME = "caption";
    private static final String DESCRIPTION_ATTRIBUTE_NAME = "description";

    public Drawing() {
    }

    public Drawing(Element element) {
        super(element);
    }

    public Drawing(EditionComponent<?> parent, EditionListener listener) {
        super(parent);
        this.setListener(listener);
    }

    @Override
    public int getTextLength() {
        return 1;
    }

    public void addPoint(ScriptoriumPoint point) {
        this.addChild(point);
    }

    public void removePoint(ScriptoriumPoint point) {
        for (ScriptoriumShape shape : this.getShapes()) {
            shape.getShape().removePoint(point);
        }
        this.removeChild(point);
    }

    public boolean isPointReferred(ScriptoriumPoint point) {
        Iterator<ScriptoriumShape> shapesIterator = this.getShapes().iterator();
        boolean found = false;
        while (shapesIterator.hasNext() && !found) {
            ScriptoriumShape shape = shapesIterator.next();
            AbstractShape<?> innerShape = shape.getShape();
            List<PointReference> references = innerShape.getPointReferences();
            Iterator<PointReference> referencesIterator = references.iterator();
            while (referencesIterator.hasNext() && !found) {
                PointReference reference = referencesIterator.next();
                if (reference.getId() != point.getId()) continue;
                found = true;
            }
        }
        return found;
    }

    public void replacePoint(ScriptoriumPoint old_point, ScriptoriumPoint new_point) {
        this.replaceChild(old_point, new_point);
    }

    public void setPoints(List<ScriptoriumPoint> points) {
        for (ScriptoriumPoint point : points) {
            this.addPoint(point);
        }
    }

    public List<ScriptoriumPoint> getPoints() {
        return this.getNodesByType(new ScriptoriumPoint());
    }

    public void addShape(ScriptoriumShape shape) {
        this.addChild(shape);
    }

    public void addAction(ComputeAction action) {
        this.addChild(action);
    }

    public List<ComputeAction> getComputeActions() {
        return this.getNodesByType(new ComputeAction());
    }

    public void removeShape(ScriptoriumShape shape) {
        this.removeChild(shape);
    }

    public void removeAction(ComputeAction action) {
        this.removeChild(action);
    }

    public void replaceShape(ScriptoriumShape old_shape, ScriptoriumShape new_shape) {
        this.replaceChild(old_shape, new_shape);
    }

    public List<ScriptoriumShape> getShapes() {
        return this.getNodesByType(new ScriptoriumShape());
    }

    public void setTransform(Transform transform) {
        Transform oldTransform = this.getTransform();
        this.replaceChild(oldTransform, transform);
    }

    public Transform getTransform() {
        Transform transform = this.getFirstOrAppendNodeByType(new Transform());
        return transform;
    }

    public void setBackgroundImage(BackgroundImage image) {
        BackgroundImage old_image = this.getBackgroundImage();
        if (old_image == null) {
            this.addChild(image);
        } else {
            this.replaceChild(old_image, image);
        }
    }

    public BackgroundImage getBackgroundImage() {
        return this.getFirstNodeByType(new BackgroundImage());
    }

    public void removeBackgroundImage() {
        BackgroundImage image = this.getBackgroundImage();
        if (image != null) {
            this.removeChild(image);
        }
    }

    public void setOrigin(int originX, int originY) {
        this.setIntAttribute(ORIGIN_X_NAME, originX);
        this.setIntAttribute(ORIGIN_Y_NAME, originY);
    }

    public void setDimensions(int width, int height) {
        this.setIntAttribute(WIDTH_ATTRIBUTE_NAME, width);
        this.setIntAttribute(HEIGHT_ATTRIBUTE_NAME, height);
    }

    public int getOriginX() {
        int originX;
        if (this.isAllZeros()) {
            Rectangle2D pointsRectangle = this.getPointsRectangle();
            originX = (int)pointsRectangle.getX();
        } else {
            originX = this.getIntAttribute(ORIGIN_X_NAME);
        }
        return originX;
    }

    public int getOriginY() {
        int originY;
        if (this.isAllZeros()) {
            Rectangle2D pointsRectangle = this.getPointsRectangle();
            originY = (int)pointsRectangle.getY();
        } else {
            originY = this.isStringYEmpty() ? this.getIntAttribute(HEIGHT_ATTRIBUTE_NAME) : this.getIntAttribute(ORIGIN_Y_NAME);
        }
        return originY;
    }

    private boolean isStringYEmpty() {
        String attribute = this.getStringAttribute(ORIGIN_Y_NAME);
        return attribute.isEmpty();
    }

    public int getWidth() {
        int width;
        if (this.isAllZeros()) {
            Rectangle2D pointsRectangle = this.getPointsRectangle();
            width = (int)pointsRectangle.getWidth();
        } else {
            width = this.getIntAttribute(WIDTH_ATTRIBUTE_NAME);
        }
        return width;
    }

    public int getHeight() {
        int height;
        if (this.isAllZeros()) {
            Rectangle2D pointsRectangle = this.getPointsRectangle();
            height = (int)pointsRectangle.getHeight();
        } else {
            height = this.getIntAttribute(HEIGHT_ATTRIBUTE_NAME);
        }
        return height;
    }

    private boolean isAllZeros() {
        int originX = this.getIntAttribute(ORIGIN_X_NAME);
        int width = this.getIntAttribute(WIDTH_ATTRIBUTE_NAME);
        int height = this.getIntAttribute(HEIGHT_ATTRIBUTE_NAME);
        return originX == 0 && this.isStringYEmpty() && width == 0 && height == 0;
    }

    private Rectangle2D getPointsRectangle() {
        List<ScriptoriumPoint> points = this.getPoints();
        double maxX = 0.0;
        double maxY = 0.0;
        double minX = 0.0;
        double minY = 0.0;
        for (ScriptoriumPoint point : points) {
            double pointY;
            double pointX = point.getX();
            if (pointX < minX) {
                minX = pointX;
            }
            if (pointX > maxX) {
                maxX = pointX;
            }
            if ((pointY = point.getY()) < minY) {
                minY = pointY;
            }
            if (!(pointY > maxY)) continue;
            maxY = pointY;
        }
        double width = maxX - minX;
        double height = maxY - minY;
        Rectangle2D.Double rectangle = new Rectangle2D.Double(minX, maxY, width, height);
        return rectangle;
    }

    public void setCaption(String caption) {
        this.setStringAttribute(CAPTION_ATTRIBUTE_NAME, caption);
    }

    public String getCaption() {
        return this.getStringAttribute(CAPTION_ATTRIBUTE_NAME);
    }

    public void setDescription(String description) {
        this.setStringAttribute(DESCRIPTION_ATTRIBUTE_NAME, description);
    }

    public String getDescription() {
        return this.getStringAttribute(DESCRIPTION_ATTRIBUTE_NAME);
    }

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Drawing make(Element element) {
        return new Drawing(element);
    }

    @Override
    public String getElementName() {
        return "drawing";
    }

    public StyleSetReference getStylesetReference() {
        return this.getFirstOrAppendNodeByType(new StyleSetReference());
    }

    public void setStyleset(StyleSetReference styleSet) {
        StyleSetReference old_set = this.getStylesetReference();
        this.replaceChild(old_set, styleSet);
    }

    public int newPointId() {
        ArrayList<Glyph> glyphs = new ArrayList<Glyph>(this.getPoints());
        return Drawing.newId(glyphs);
    }

    public int newShapeId() {
        ArrayList<Glyph> glyphs = new ArrayList<Glyph>(this.getShapes());
        return Drawing.newId(glyphs);
    }

    private static int newId(List<Glyph> glyphs) {
        int maxId = 0;
        for (Glyph glyph : glyphs) {
            if (maxId >= glyph.getId()) continue;
            maxId = glyph.getId();
        }
        return maxId + 1;
    }

    public ScriptoriumPoint getPoint(PointReference reference) {
        for (ScriptoriumPoint point : this.getPoints()) {
            if (point.getId() != reference.getId()) continue;
            return point;
        }
        return null;
    }

    public ScriptoriumShape getShape(ShapeReference reference) {
        for (ScriptoriumShape shape : this.getShapes()) {
            if (shape.getId() != reference.getId()) continue;
            return shape;
        }
        return null;
    }

    public void addGlyphGroup(GlyphGroup group) {
        group.setDrawing(this);
        this.addChild(group);
    }

    public void removeGlyphGroup(GlyphGroup group) {
        this.removeChild(group);
    }

    public List<GlyphGroup> getGlyphGroups() {
        List<GlyphGroup> groups = this.getNodesByType(new GlyphGroup());
        for (GlyphGroup group : groups) {
            group.setDrawing(this);
        }
        return groups;
    }

    @Override
    public String toString() {
        String description = this.getDescription();
        return description.length() == 0 ? "---" : description;
    }
}

