/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.EditionListener;
import org.homelinux.elabor.scriptorium.ecomponents.EditionValidator;
import org.homelinux.elabor.scriptorium.ecomponents.ImpossibleSplitException;
import org.homelinux.elabor.scriptorium.ecomponents.Text;
import org.homelinux.elabor.scriptorium.ecomponents.ValidationException;
import org.homelinux.elabor.scriptorium.ecomponents.ValuedComposite;
import org.homelinux.elabor.scriptorium.ecomponents.iterators.ElementsIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class EditionComposite<T extends EditionComponent<T>>
extends EditionComponent<T> {
    public EditionComposite() {
    }

    public EditionComposite(Element element) {
        super(element);
    }

    public EditionComposite(EditionComponent<?> parent) {
        super(parent);
    }

    private void checkInsertion(boolean normalize) throws ValidationException {
        this.validate();
        if (normalize) {
            this.normalize();
        }
    }

    private void validate() throws ValidationException {
        EditionValidator validator = EditionValidator.getInstance();
        if (validator != null) {
            try {
                validator.validate(this);
            }
            catch (Exception e) {
                throw new ValidationException(e);
            }
        }
    }

    public void addChild(EditionComponent<?> child) throws ValidationException {
        this.addChildNoCheck(child);
        this.checkInsertion(true);
        this.valueChanged(null);
    }

    public void addChildNoCheck(EditionComponent<?> child) {
        Element element = this.getElement();
        Element childElement = child.getElement();
        element.appendChild(childElement);
    }

    public void createChild(EditionComponent<?> child) throws ValidationException {
        Document document = this.getDocument();
        child.createElement(document);
        this.addChild(child);
    }

    public void addChildAfter(EditionComponent<?> previous, EditionComponent<?> child) throws ValidationException {
        Element element = this.getElement();
        Element childElement = child.getElement();
        EditionComponent<?> nextComponent = previous.getNextComponent();
        if (nextComponent == null) {
            element.appendChild(childElement);
        } else {
            Element next = nextComponent.getElement();
            element.insertBefore(childElement, next);
        }
        this.checkInsertion(true);
        this.valueChanged(null);
    }

    public void addFirstChild(EditionComponent<?> child) throws ValidationException {
        Element element = this.getElement();
        Element childElement = child.getElement();
        Node firstChild = element.getFirstChild();
        element.insertBefore(childElement, firstChild);
        this.checkInsertion(true);
        this.valueChanged(null);
    }

    protected void removeAllChildren() {
        Node child;
        Element element = this.getElement();
        while ((child = element.getFirstChild()) != null) {
            element.removeChild(child);
        }
    }

    public void removeChild(EditionComponent<?> child) {
        Element childElement = child.getElement();
        Node parentNode = childElement.getParentNode();
        parentNode.removeChild(childElement);
        this.normalize();
        this.valueChanged(null);
    }

    public void downgradeComponent(ValuedComposite<?> component) throws ValidationException {
        List<EditionComponent<?>> contents = component.getContents();
        this.multipleReplaceChild(component, contents);
        this.valueChanged(null);
    }

    public void replaceChild(EditionComponent<?> old_eC, EditionComponent<?> new_eC) throws ValidationException {
        Element element = this.getElement();
        Element newElement = new_eC.getElement();
        Element oldElement = old_eC.getElement();
        element.replaceChild(newElement, oldElement);
        this.validate();
        this.normalize();
        this.valueChanged(null);
    }

    private <eN extends EditionComponent<?>> void multipleReplaceChild(eN old_ec, List<eN> new_ecs) throws ValidationException {
        Element parent = this.getElement();
        Element old_child = old_ec.getElement();
        for (EditionComponent new_ec : new_ecs) {
            Element new_child = new_ec.getElement();
            parent.insertBefore(new_child, old_child);
        }
        parent.removeChild(old_child);
        this.validate();
    }

    protected <eN extends EditionComponent<?>> eN getFirstNodeByType(eN edition_component) {
        ArrayList<eN> editionComponents = new ArrayList<eN>();
        editionComponents.add(edition_component);
        return (eN)this.getFirstNodeByType(editionComponents);
    }

    protected <eN extends EditionComponent<?>> eN getFirstNodeByType(Iterable<eN> edition_components) {
        EditionComponent retValue = null;
        if (this.getElement() != null) {
            ElementsIterator elementsIterator = new ElementsIterator(this);
            while (retValue == null && elementsIterator.hasNext()) {
                Element element = elementsIterator.next();
                Iterator<eN> componentsIterator = edition_components.iterator();
                while (retValue == null && componentsIterator.hasNext()) {
                    EditionComponent component = (EditionComponent)componentsIterator.next();
                    String elementName = component.getElementName();
                    if (!element.getNodeName().equals(elementName)) continue;
                    component.setElement(element);
                    EditionListener listener = this.getListener();
                    component.setListener(listener);
                    retValue = component;
                }
            }
        }
        return (eN)retValue;
    }

    protected <eN extends EditionComponent<?>> eN getFirstOrAppendNodeByType(eN component) throws ValidationException {
        if (this.getFirstNodeByType(component) == null) {
            Element element = this.getElement();
            Document ownerDocument = element.getOwnerDocument();
            component.createElement(ownerDocument);
            Element componentElement = component.getElement();
            EditionListener listener = this.getListener();
            component.make(componentElement, listener);
            component.initialise();
            element.appendChild(componentElement);
            this.checkInsertion(false);
        }
        return component;
    }

    protected <eC extends EditionComponent<?>> eC getOrCreateFirstNodeByType(eC component) throws ValidationException {
        if (this.getFirstNodeByType(component) == null) {
            Element element = this.getElement();
            Document ownerDocument = element.getOwnerDocument();
            component.createElement(ownerDocument);
            Element componentElement = component.getElement();
            Node firstChild = element.getFirstChild();
            element.insertBefore(componentElement, firstChild);
            this.checkInsertion(false);
        }
        return component;
    }

    @Override
    public List<EditionComponent<?>> getChildren() {
        List<EditionComponent<?>> components = super.getChildren();
        for (Element child : new ElementsIterator(this)) {
            EditionListener listener = this.getListener();
            EditionComponent<?> edElement = EditionComponentFactory.createEditionElement(child, listener);
            components.add(edElement);
        }
        return components;
    }

    @Override
    public boolean contains(EditionComponent<?> component) {
        boolean retVal = false;
        if (this.equals(component)) {
            retVal = true;
        } else {
            for (EditionComponent<?> child : this.getChildren()) {
                retVal = child.contains(component);
                if (retVal) break;
            }
        }
        return retVal;
    }

    @Override
    public void normalize() {
        List<EditionComponent<?>> children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            EditionComponent<?> child = children.get(i);
            if (i + 1 == children.size() || !child.collapse(children.get(i + 1))) {
                ++i;
            }
            child.normalize();
        }
    }

    @Override
    public void relativize(File oldDir, File newDir) {
        for (EditionComponent<?> child : this.getChildren()) {
            child.relativize(oldDir, newDir);
        }
    }

    public String toString() {
        String to_string = "";
        for (EditionComponent<?> component : this.getChildren()) {
            to_string = to_string.concat(component.toString());
        }
        return to_string;
    }

    public void defineComposite(Text text, int offset, int length, ValuedComposite<?> composite) throws ImpossibleSplitException {
        List<Text> splittedText = text.getSplittedText(offset, length);
        this.multipleReplaceChild(text, splittedText);
        Text tokenText = splittedText.get(1);
        composite.addContent(tokenText.makeCopy(new Text()));
        this.replaceChild(tokenText, composite);
    }

    public void insertComponent(Text text, int offset, EditionComponent<?> component) throws ImpossibleSplitException {
        List<Text> splittedText = text.getSplittedText(offset, 0);
        try {
            this.multipleReplaceChild(text, splittedText);
            Text tokenText = splittedText.get(1);
            this.replaceChild(tokenText, component);
        }
        catch (Exception e) {
            throw new ImpossibleSplitException(e);
        }
    }
}

