/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.NonemptyValuedComposite;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.w3c.dom.Element;

public class DateToken
extends NonemptyValuedComposite<DateToken>
implements ComponentFactory<DateToken>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DATE_ATTRIBUTE_NAME = "date";

    public DateToken() {
    }

    public DateToken(EditionComponent<?> parent) {
        super(parent);
    }

    public DateToken(Element element) {
        super(element);
    }

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }

    public void setDate(Date date) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.UK);
        this.setStringAttribute(DATE_ATTRIBUTE_NAME, dateFormat.format(date));
    }

    public void removeDate() {
        this.setStringAttribute(DATE_ATTRIBUTE_NAME, "");
    }

    public Date getDate() {
        Date date;
        String dateString = this.getStringAttribute(DATE_ATTRIBUTE_NAME);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.UK);
        try {
            date = dateFormat.parse(dateString);
        }
        catch (ParseException exc) {
            date = null;
        }
        return date;
    }

    @Override
    public String getElementName() {
        return "date_token";
    }

    @Override
    public DateToken make(Element element) {
        return new DateToken(element);
    }
}

