/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.pdf;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.Jpeg;
import com.itextpdf.text.Paragraph;
import java.net.URL;
import java.util.Map;
import org.homelinux.elabor.pdf.InternalException;
import org.homelinux.elabor.pdf.NodeHandler;
import org.homelinux.elabor.pdf.NodeHelper;
import org.homelinux.elabor.pdf.TypedField;
import org.w3c.dom.Node;

public class ImageHandler
implements NodeHandler {
    @Override
    public void handle(Paragraph paragraph, Map<String, Object> valuesMap, Map<String, ? extends TypedField> typesMap, Node node) {
        String src = NodeHelper.getAttribute(node, "src");
        int scale = NodeHelper.getIntAttribute(node, "scale", 100);
        int assey = NodeHelper.getIntAttribute(node, "assey", 0);
        Class<?> thisClass = this.getClass();
        ClassLoader classLoader = thisClass.getClassLoader();
        URL url = classLoader.getResource(src + ".jpg");
        try {
            Jpeg image = new Jpeg(url);
            image.scalePercent((float)scale);
            float height = image.getScaledHeight();
            paragraph.setSpacingBefore(height);
            Chunk chunk = new Chunk((Image)image, 0.0f, (float)assey);
            paragraph.add((Element)chunk);
            paragraph.add(" ");
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }
}

