/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.images;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImagesHelper {
    private ImagesHelper() {
    }

    public static byte[] getThumbnail(File file, int thumbWidth) throws IOException {
        BufferedImage image = ImageIO.read(file);
        return ImagesHelper.getThumbnail(image, thumbWidth);
    }

    public static byte[] getThumbnail(Image image, int thumbWidth) throws IOException {
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        double imageRatio = (double)imageWidth / (double)imageHeight;
        int thumbHeight = (int)((double)thumbWidth / imageRatio);
        BufferedImage thumbImage = new BufferedImage(thumbWidth, thumbHeight, 1);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawImage(image, 0, 0, thumbWidth, thumbHeight, null);
        graphics2D.dispose();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)thumbImage, "jpg", out);
        return out.toByteArray();
    }
}

