/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.file;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import org.homelinux.elabor.file.ZipInputStreamAction;

class FolderWriterAction
implements ZipInputStreamAction {
    private File folder;

    public FolderWriterAction(File folder) {
        this.folder = folder;
    }

    @Override
    public long execute(InputStream zis, ZipEntry entry) throws IOException {
        long entrySize = 0L;
        byte[] buffer = new byte[2048];
        File of = new File(this.folder, entry.getName());
        try (FileOutputStream fos = new FileOutputStream(of);
             BufferedOutputStream bos = new BufferedOutputStream(fos, buffer.length);){
            int size;
            while ((size = zis.read(buffer, 0, buffer.length)) != -1) {
                entrySize += (long)size;
                bos.write(buffer, 0, size);
            }
        }
        return entrySize;
    }
}

