/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.poi.openxml4j.util.ZipArchiveThresholdInputStream;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.homelinux.elabor.file.FolderWriterAction;
import org.homelinux.elabor.file.NotDirectoryException;
import org.homelinux.elabor.file.PatternFileFilter;
import org.homelinux.elabor.file.ZipInputStreamAction;
import org.homelinux.elabor.text.NewLine;

public class FileSystemTools {
    private FileSystemTools() {
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------"));
        File file = Files.createTempFile(prefix, suffix, attr).toFile();
        boolean ok = file.setReadable(true, true);
        ok &= file.setWritable(true, true);
        if (!(ok &= file.setExecutable(true, true))) {
            throw new RuntimeException("failed to create temporary file");
        }
        return file;
    }

    public static File derive(File file, String extension) {
        File parent = file.getParentFile();
        String name = file.getName();
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            name = name.substring(0, index);
        }
        name = name + '.' + extension;
        return new File(parent, name);
    }

    public static File copy(File source, File destination) throws IOException {
        File output = destination.isDirectory() ? new File(destination, source.getName()) : destination;
        try (FileInputStream inputStream = new FileInputStream(source);
             FileChannel inputChannel = inputStream.getChannel();
             FileOutputStream outputStream = new FileOutputStream(output);
             FileChannel outputChannel = outputStream.getChannel();){
            inputChannel.transferTo(0L, source.length(), outputChannel);
        }
        return output;
    }

    public static void read(File file, Writer writer) throws IOException {
        try (FileReader input = new FileReader(file);
             BufferedReader reader = new BufferedReader(input);){
            String line;
            while ((line = reader.readLine()) != null) {
                writer.write(line + NewLine.NEW_LINE);
            }
        }
    }

    public static void zip(File zipFile, File folder) throws IOException {
        final Path path = Paths.get(folder.getAbsolutePath(), new String[0]);
        try (FileOutputStream outputStream = new FileOutputStream(zipFile);
             final ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);){
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                    Path targetFile = path.relativize(file);
                    zipOutputStream.putNextEntry(new ZipEntry(targetFile.toString()));
                    byte[] bytes = Files.readAllBytes(file);
                    zipOutputStream.write(bytes, 0, bytes.length);
                    zipOutputStream.closeEntry();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static void unzip(File zippedFile, File folder) throws IOException {
        FolderWriterAction folderWriter = new FolderWriterAction(folder);
        FileSystemTools.unzip(zippedFile, folderWriter);
    }

    public static long unzip(File zippedFile, ZipInputStreamAction folderWriter) throws IOException, ZipException {
        long size = 0L;
        try (ZipSecureFile zipFile = new ZipSecureFile(zippedFile);){
            Enumeration zipEntries = zipFile.getEntries();
            while (zipEntries.hasMoreElements()) {
                ZipArchiveEntry zipEntry = (ZipArchiveEntry)zipEntries.nextElement();
                ZipArchiveThresholdInputStream zipInputStream = zipFile.getInputStream(zipEntry);
                try {
                    size += folderWriter.execute((InputStream)zipInputStream, (ZipEntry)zipEntry);
                }
                finally {
                    if (zipInputStream == null) continue;
                    zipInputStream.close();
                }
            }
        }
        return size;
    }

    public static boolean isChildren(File folder, File file) {
        File parent;
        for (parent = file.getParentFile(); parent != null && !parent.equals(folder); parent = parent.getParentFile()) {
        }
        return parent != null;
    }

    public static URI getRelativeURI(File folder, File file) {
        URI folderURI = folder.toURI().normalize();
        URI fileURI = file.toURI().normalize();
        return folderURI.relativize(fileURI);
    }

    public static File getFileFromUri(File folder, URI file) {
        URI folderURI = folder.toURI().normalize();
        URI fileUri = folderURI.resolve(file);
        return new File(fileUri);
    }

    public static boolean clean(File folder) {
        File[] files;
        boolean ok = true;
        if (folder.exists() && (files = folder.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    ok = ok && FileSystemTools.clean(file);
                }
                ok = ok && file.delete();
            }
        }
        return ok;
    }

    public static void folderCopy(File source, File destination) throws NotDirectoryException, IOException {
        Logger logger = Logger.getLogger(FileSystemTools.class.getName());
        logger.info("copying " + source.getAbsolutePath() + " to " + destination.getAbsolutePath());
        if (!source.isDirectory()) {
            throw new NotDirectoryException("invalid.file", source);
        }
        if (!destination.isDirectory()) {
            throw new NotDirectoryException("invalid.file", destination);
        }
        File[] files = source.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    FileSystemTools.folderToFolderCopy(file, destination);
                    continue;
                }
                FileSystemTools.copy(file, destination);
            }
        }
    }

    private static void folderToFolderCopy(File source, File destination) throws NotDirectoryException, IOException {
        File output = new File(destination, source.getName());
        output.mkdir();
        FileSystemTools.folderCopy(source, output);
    }

    public static FilenameFilter getNullFileFilter() {
        return new PatternFileFilter(".*", "tutti i file");
    }
}

