/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.TimeZone;

public enum DbmsType {
    POSTGRES("org.postgresql.Driver", "jdbc:postgresql:", 5432),
    ORACLE("oracle.jdbc.OracleDriver", "jdbc:oracle:thin:@", 1521),
    DUMMY(null, null, 0);

    private String driver;
    private String baseUrl;
    private int defaultPort;

    private DbmsType(String driver, String url, int port) {
        this.driver = driver;
        this.baseUrl = url;
        this.defaultPort = port;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getBaseUrl() {
        return this.getBaseUrl("localhost", this.defaultPort);
    }

    private String getBaseUrl(String host, int port) {
        return this.baseUrl + "//" + host + ":" + port + "/";
    }

    public void loadDriver() throws ClassNotFoundException {
        Class.forName(this.driver);
    }

    public Connection getConnection(String dbName, String user, String password) throws SQLException, ClassNotFoundException {
        this.loadDriver();
        String url = this.getBaseUrl() + dbName;
        return DriverManager.getConnection(url, user, password);
    }

    public Connection getConnection(String host, String dbName, String user, String password) throws SQLException, ClassNotFoundException {
        return this.getConnection(host, this.defaultPort, dbName, user, password);
    }

    public Connection getConnection(String host, int port, String dbName, String user, String password) throws SQLException, ClassNotFoundException {
        Connection connection;
        if (this.driver == null) {
            connection = null;
        } else {
            this.loadDriver();
            TimeZone.setDefault(TimeZone.getTimeZone("CET"));
            String url = this.getBaseUrl(host, port) + dbName;
            connection = DriverManager.getConnection(url, user, password);
        }
        return connection;
    }
}

