/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.calendar;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.ui.UIConstants;

public class MonthIterator
implements Iterator<Month> {
    private int year;
    private Month start;
    private Month current;
    private Month end;

    public MonthIterator() {
        this(new ElaborCalendar().getAnno());
    }

    public MonthIterator(int year) {
        this(Month.JANUARY, year);
    }

    public MonthIterator(Month start, int year) {
        this(start, Month.DECEMBER, year);
    }

    public MonthIterator(Month start, Month end, int year) {
        this.year = year;
        this.start = start;
        this.end = end;
        this.current = null;
    }

    public int getYear() {
        return this.year;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(UIConstants.getInstance().illegalOperationString);
    }

    @Override
    public boolean hasNext() {
        return this.current == null || this.current != this.end;
    }

    @Override
    public Month next() {
        if (this.hasNext()) {
            this.current = this.current == null ? this.start : this.current.next();
        } else {
            throw new NoSuchElementException();
        }
        return this.current;
    }
}

