/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.calendar;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class DailyIterator
implements Iterator<Date>,
Iterable<Date> {
    private Date start;
    private Date end;
    private List<Date> days;
    private int index;

    public DailyIterator(Date start, Date end) {
        this.start = start;
        this.end = end;
        this.index = 0;
        this.days = new ArrayList<Date>();
        Calendar cursor = Calendar.getInstance();
        cursor.setTime(this.start);
        cursor.set(11, 0);
        cursor.set(12, 0);
        cursor.set(13, 0);
        cursor.set(14, 0);
        while (cursor.getTime().before(this.end)) {
            this.days.add(cursor.getTime());
            cursor.add(5, 1);
        }
    }

    @Override
    public Iterator<Date> iterator() {
        return this.days.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.days.size() > this.index;
    }

    @Override
    public Date next() {
        Date day;
        if (this.hasNext()) {
            day = this.days.get(this.index);
            ++this.index;
        } else {
            throw new NoSuchElementException();
        }
        return day;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

